/**************************************************************************//**
 * @file        Flash.h
 * @version     V1.0
 * $Revision:   0 $
 * $Date:         $
 * @brief       FLASH Driver Header File
 *
 * @note
 * Copyright (C) 2016 AMICCOM Electronics Corp. All rights reserved.
 ******************************************************************************/
#ifndef __FLASH_H__
#define __FLASH_H__
#include "A9139M0.h"
#define A9139M0_FLASH_PAGE_SIZE             (128)
#define A9139M0_FLASH_SECTOR_SIZE           (4*1024)
#define A9139M0_FLASH_CHIP_NUMBER           (1)
#define A9139M0_ROM_SIZE                    (A9139M0_FLASH_CHIP_SIZE * A9139M0_FLASH_CHIP_NUMBER)
#define A9139M0_FLASH_CHIP_SIZE             (128*1024) 
#define A9139M0_FLASH_PAGE_ADDRESS_MASK     0xFFFFFF80
#define A9139M0_FLASH_SECTOR_ADDRESS_MASK   0xFFFFF000
#define A9139M0_FLASH_BLANK_VALUE           0xFFFFFFFF 
/** @addtogroup A9139M_Driver Standard Driver
    @{
*/
/** @addtogroup FLASH_Driver UART Driver
    @{
*/
/**
 * @brief  Write data from u32buf[] to flash
 */
extern uint32_t Flash_Write_U32( uint32_t address, uint32_t u32buf[], uint8_t length );

/**
 * @brief  Write data from u8buf[] to flash
 */
extern uint32_t Flash_Write_U8( uint32_t address, uint8_t u8buf[], uint8_t length );

/**
 * @brief  Erase 1 paage (32 WORDs = 128 Bytes) flash
 */
extern uint32_t Flash_PageErase( uint32_t address );

/**
 * @brief  Erase 1 sector (32x32 WORD = 4K Bytes) flash
 */
extern uint32_t Flash_SectorErase( uint32_t address );


/*@}*/ /* end of group FLASH_Driver */
/*@}*/ /* end of group A8107M_Driver */
extern uint32_t IAPLIB_FlashProtect(void);

extern uint32_t iapLib_flash_action(uint32_t address, uint32_t action, uint32_t length);

extern uint32_t IAPLIB_FlashPageWriteAndCheck(uint32_t address, uint32_t *buf);

extern uint32_t IAPLIB_FlashPageProgramAndCheck(uint32_t address, uint32_t *buf);

extern uint32_t IAPLIB_FlashSectorEraseAndCheck(uint32_t address);

#endif
